--
-- file prepared: 15 May 2024 23:19:08.053, using fd633c
--
self_ID = "p38"
declare_plugin(self_ID,
{
	displayName = _("p38"),
	developerName = _("Half Science, the 'clay pigeon' series"),  --see artistic credits in the readme.txt

	image = "FC.bmp",
	installed = true,
	dirName = current_mod_path,
	fileMenuName = _("p38"),

	version = " ",
	state = "installed",
	info = _("The Lockheed P-38 Lightning is an single-seat, twin piston-engined fighter aircraft used by the United States Army Air Corps (USAAC) during World War II. It incorporated a distinctive twin-boom design with a central nacelle containing the cockpit and armament. Unusual for an early-war fighter design, both engines were supplemented by turbo-superchargers, making it one of the earliest Allied fighters capable of performing well at high altitudes. The Lightning was extremely forgiving in flight and could be mishandled in many ways, but the roll rate in early versions was considered low (later addressed with the introduction of hydraulically boosted ailerons). Overall, the P-38 suffered its highest losses in the Mediterranean Theater, and was used most extensively and successfully in the Pacific Theater, where it proved more suited, combining exceptional range with the reliability of two engines for long missions over water. The P-38 was credited with destroying more Japanese aircraft than any other USAAF fighter. While it could not out-turn the A6M Zero and most other Japanese fighters when flying below 200 mph (320 km/h), its superior speed coupled with a good rate of climb meant that it could use energy tactics, making multiple high-speed passes at its target. (source: https://en.wikipedia.org/wiki/Lockheed_P-38_Lightning) "),

	update_id = "p38",

	Skins =
	{
		{
			name = _("p38"),
			dir = "Theme"
		},
	},
	Missions =
	{
		{
			name = _("p38"),
			dir = "Missions",
		},
	},
	LogBook =
	{
		{
			name = _("p38"),
			type = "p38",
		},
	},
	InputProfiles =
	{
		["p38"] = current_mod_path .. '/Input/p38',
	},
})
----------------------------------------------------------------------------------------
mount_vfs_texture_path(current_mod_path.."/Textures")
mount_vfs_model_path(current_mod_path.."/Shapes")
dofile(current_mod_path.."/Views.lua")
dofile(current_mod_path.."/weapons.lua")
make_view_settings('p38', ViewSettings, SnapViews)
make_flyable('p38', current_mod_path..'/Cockpit/Scripts/', { nil, old = 54 }, current_mod_path..'/comm.lua')
dofile(current_mod_path..'/p38.lua')
------------------------------------------------------------------------------------ -
plugin_done()

